package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.NakedModifier;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class AVLD extends Modifier {

	private static String xmlID = "AVLD";

	private double nonStandardCost = .75;

	private Adder commonDefense;

	public AVLD(Element root) {
		super(root, AVLD.xmlID);
		commonDefense = new Adder();
		commonDefense.setFixedValue(true);
		commonDefense.setXMLID("COMMONDEFENSE");
		commonDefense.setSelectable(true);
		commonDefense.setDisplayInString(false);
		commonDefense.setDisplay("Defense is Extraordinarily Common");
		commonDefense.setBaseCost(0);
		commonDefense.setExclusive(true);
	}

	@Override
	public double getBaseCost() {
		if (isStandardDefense()
				&& findObjectByID(getAssignedAdders(), "COMMONDEFENSE") == null) {
			return baseCost;
		} else {
			return nonStandardCost;
		}
	}

	@Override
	public ArrayList<Adder> getAvailableAdders() {
		ArrayList<Adder> ret = (ArrayList<Adder>) super.getAvailableAdders()
				.clone();
		if (isStandardDefense()
				&& findObjectByID(getAssignedAdders(), "COMMONDEFENSE") == null) {
			ret.add(commonDefense);
		} else if (isStandardDefense()) {
			ret
					.add((Adder) findObjectByID(getAssignedAdders(),
							"COMMONDEFENSE"));
		}
		return ret;
	}

	private boolean isStandardDefense() {
		return ((parent == null) || parent.getDefense("AVLD").equals("NORMAL") || (parent instanceof NakedModifier));
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();
		for (Adder ad : getAssignedAdders()) {
			if (ad.displayInString()) {
				if (adderString.length() > 0) {
					adderString += ", ";
				}
				adderString += ad.getAlias() + " ("
						+ getFraction(ad.getBaseCost()) + ")";
			}
			val -= ad.getBaseCost();
		}

		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		ret += " (";
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += getInput();
			ret += "; ";
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		ret += getFraction(val) + ")";
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}

	@Override
	public double getMaxCost() {
		return getBaseCost();
	}

	@Override
	public double getMinimumCost() {
		return getBaseCost();
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (o instanceof NakedModifier) {
			return "";
		}
		if (o.getTarget().equals("SELFONLY") || o.getTarget().equals("N/A")) {
			return getDisplay()
					+ " can only be applied to abilities which affect others.";
		}
		if (o.getDefense().equals("NONE")) {
			return getDisplay()
					+ " can only be applied to abilities which act against one of the standard Defense types (Normal, Power, Flash, Mental).";
		} else {
			return "";
		}
	}

	@Override
	protected void init(Element element) {
		super.init(element);
		availableCheck = false;
		String check = XMLUtility.getValue(element, "NONSTANDARDDEFENSE");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				nonStandardCost = Double.parseDouble(check);
			} catch (Exception exp) {
				nonStandardCost = .75;
			}
		}
	}

}